from sqlalchemy import Column, Integer, String, Enum, ForeignKey, Boolean
from sqlalchemy.orm import relationship
import enum
from app.db.base import Base


class RoleEnum(str, enum.Enum):
    COMPANY_EMPLOYEE = "COMPANY_EMPLOYEE"
    TRAINER = "TRAINER"
    PARENT = "PARENT"


class User(Base):
    __tablename__ = "users"

    id = Column(Integer, primary_key=True, index=True)
    email = Column(String, unique=True, nullable=False, index=True)
    hashed_password = Column(String, nullable=False)
    first_name = Column(String, nullable=True)
    last_name = Column(String, nullable=True)
    role = Column(Enum(RoleEnum), nullable=False)
    is_active = Column(Boolean, nullable=False, default=True)

    # relations
    club_id = Column(Integer, ForeignKey("clubs.id"), nullable=True)
    club = relationship("Club", foreign_keys=[club_id], back_populates="users")
    
    # Clubs that this admin manages (only for COMPANY_EMPLOYEE role)
    managed_clubs = relationship("Club", foreign_keys="Club.admin_id", back_populates="admin")

    # parent-child relation: store children in separate table
