from sqlalchemy import Column, Integer, String, ForeignKey, DateTime, Boolean, Text
from sqlalchemy.orm import relationship
from datetime import datetime
from app.db.base import Base


class WorkOrder(Base):
    __tablename__ = "work_orders"
    
    id = Column(Integer, primary_key=True, index=True)
    work_order_number = Column(String, nullable=False, unique=True)  # e.g., "WO_APO_20260130_1425"
    order_ids = Column(String, nullable=False)  # Comma-separated list of order IDs (e.g., "1,2,3,4,5,6")
    club_id = Column(Integer, ForeignKey("clubs.id"), nullable=False)
    created_by_id = Column(Integer, ForeignKey("users.id"), nullable=False)  # Admin who created it
    created_at = Column(DateTime, nullable=False, default=datetime.utcnow)
    notes = Column(Text, nullable=True)
    model = Column(String, nullable=True)  # Model/title for the work order
    due_date = Column(DateTime, nullable=True)  # Due date for the work order
    is_archived = Column(Boolean, nullable=False, default=False)
    archived_at = Column(DateTime, nullable=True)
    
    club = relationship("Club")
    created_by = relationship("User", foreign_keys=[created_by_id])
    
    def get_order_ids_list(self):
        """Convert comma-separated string to list of integers"""
        if not self.order_ids:
            return []
        return [int(oid.strip()) for oid in self.order_ids.split(',')]
