"""
Create all database tables based on SQLAlchemy models.
Run this script to initialize the database schema.
"""
from app.db.session import engine
from app.db.base import Base

# Import all models so they are registered with Base
from app.models.user import User
from app.models.club import Club
from app.models.child import Child
from app.models.invite import Invite
from app.models.product import Product, ProductVariant
from app.models.order import Order, OrderItem
from app.models.work_order import WorkOrder
from app.models.basket import Basket, BasketItem

def create_tables():
    """Create all tables in the database."""
    print("Creating database tables...")
    Base.metadata.create_all(bind=engine)
    print("✓ All tables created successfully!")

if __name__ == "__main__":
    create_tables()
